<?php
/* --------------------------------------------------------------
   BaseApiV3Controller.php 2020-03-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Application;

use Slim\Http\Response;
use Slim\Http\ServerRequest as Request;

/**
 * Class BaseApiV3Controller
 *
 * @package Gambio\Api\Application
 */
class BaseApiV3Controller
{
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        $uri        = $request->getUri();
        $apiBaseUrl = $uri->getScheme() . '://' . $uri->getHost() . $uri->getPath();
        
        return $response->withJson([
                                       'withdrawals'     => $apiBaseUrl . '/withdrawals',
                                       'parcel-services' => $apiBaseUrl . '/parcel-services',
                                       'tracking-codes'  => $apiBaseUrl . '/tracking-codes',
                                   ]);
    }
}